
clear all;  % clear all variables
close all;  % close all graphs
clc;
obsd=open('datatask9.mat');
obs=obsd.datareg(:,1)-obsd.datareg(:,2);
z=obsd.datareg(:,3);


sigma=fminsearch(@LogLikelihood,[0,0]);
%sigma=fminsearch(@LogLikelihood,[0]);
[upd,pred,T,V,S,F]=KalmanFilter (sigma, obs);
smooth=KalmanSmoother(T,upd,pred);

save('sigma', 'sigma');

subplot(2,1,1)
plot(obs);
hold on;
title('Observation and Kalman Filter Prediction (Dashed line is updated series)')
plot(upd(2:end,1),'--r','Linewidth',2);
hold off;

subplot(2,1,2);
plot(obs);
hold on;
title('Observation and Kalman Smoother (Dashed line is smoother)')
plot(smooth(2:end,1),'--r','Linewidth',2);
hold off

saveas(gcf,'fig1','fig');


for d=2:size(smooth,1)
    result(d-1,1)=smooth(d,1);
    result(d-1,2)=sqrt(smooth(d,2));
end;
